/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.impl;

import com.cisco.pt.ptmp.ConnectionNegotiationProperties;
import com.cisco.pt.ptmp.impl.ConnectionNegotiationPropertiesImpl;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OptionsManager {
    private static Log logger = LogFactory.getLog(OptionsManager.class);
    Properties props;
    Properties defaultProps;
    String propFile;
    private static String defaultPropFile = "pt_cep.properties";
    private static Map<String, Integer> connectOptions = new HashMap<String, Integer>();
    private static OptionsManager instance;

    private OptionsManager() {
        this(defaultPropFile);
    }

    private OptionsManager(String propFileName) {
        this.propFile = propFileName;
        this.setDefaultProps();
        this.props = new Properties(this.defaultProps);
        try {
            InputStream inStream = this.getClass().getClassLoader().getResourceAsStream(this.propFile);
            if (inStream == null) {
                inStream = new FileInputStream(this.propFile);
            }
            this.props.load(inStream);
        }
        catch (FileNotFoundException fnfe) {
            logger.error((Object)("Error loading properties from file " + this.propFile));
            logger.error((Object)fnfe.getMessage());
        }
        catch (IOException ioe) {
            logger.error((Object)("Error loading properties from file " + this.propFile));
            logger.error((Object)ioe.getMessage());
        }
    }

    public static OptionsManager getInstance() {
        if (instance == null) {
            instance = new OptionsManager();
        }
        return instance;
    }

    public static OptionsManager getInstance(String propFileName) {
        if (instance == null) {
            instance = new OptionsManager(propFileName);
        }
        return instance;
    }

    private void setDefaultProps() {
        this.defaultProps = new Properties();
        this.defaultProps.setProperty("pt.cep.ptmp.uid", "{c6fbf435-3234-48bb-af04-debc4e4cf9f3}");
        this.defaultProps.setProperty("pt.cep.ptmp.signature", "PTMP");
        this.defaultProps.setProperty("pt.cep.ptmp.version", "1");
        this.defaultProps.setProperty("pt.cep.encoding", "TEXT_ENCODING");
        this.defaultProps.setProperty("pt.cep.encryption", "NO_ENCRYPTION");
        this.defaultProps.setProperty("pt.cep.compression", "NOT_COMPRESSED");
        this.defaultProps.setProperty("pt.cep.authentication", "MD5_AUTH");
        this.defaultProps.setProperty("pt.cep.auth.secret", "cisco");
        this.defaultProps.setProperty("pt.cep.auth.application", "net.netacad.cisco.ipctest");
        this.defaultProps.setProperty("pt.cep.keepAlivePeriod", "0");
    }

    public String getStringOpt(String optName) {
        return this.props.getProperty(optName);
    }

    public int getIntOpt(String optName) {
        int val = 0;
        String valStr = this.props.getProperty(optName);
        if (valStr != null) {
            try {
                val = Integer.parseInt(valStr);
            }
            catch (NumberFormatException nfe) {
                logger.error((Object)nfe.getMessage());
            }
        }
        return val;
    }

    public ConnectionNegotiationProperties getConnectOpts() {
        ConnectionNegotiationPropertiesImpl connProps = new ConnectionNegotiationPropertiesImpl();
        connProps.setSignature(this.props.getProperty("pt.cep.ptmp.signature"));
        connProps.setVersion(this.getIntOpt("pt.cep.ptmp.version"));
        connProps.setClientUid(this.props.getProperty("pt.cep.ptmp.uid"));
        connProps.setEncoding(this.getIntFromPmtpOpt(this.props.getProperty("pt.cep.encoding")));
        connProps.setEncryption(this.getIntFromPmtpOpt(this.props.getProperty("pt.cep.encryption")));
        connProps.setCompression(this.getIntFromPmtpOpt(this.props.getProperty("pt.cep.compression")));
        connProps.setAuthentication(this.getIntFromPmtpOpt(this.props.getProperty("pt.cep.authentication")));
        connProps.setAuthenticationSecret(this.props.getProperty("pt.cep.auth.secret"));
        connProps.setAuthenticationApplication(this.props.getProperty("pt.cep.auth.application"));
        connProps.setClientTimestamp(ConnectionNegotiationProperties.yyyyMMddhhmmssDateFormatter.format(new Date()));
        connProps.setKeepAlivePeriod(this.getIntOpt("pt.cep.keepAlivePeriod"));
        return connProps;
    }

    private int getIntFromPmtpOpt(String propTag) {
        Integer valInteger = connectOptions.get(propTag);
        return valInteger != null ? valInteger : 0;
    }

    static {
        connectOptions.put("TEXT_ENCODING", 1);
        connectOptions.put("BINARY_ENCODING", 2);
        connectOptions.put("NO_ENCRYPTION", 1);
        connectOptions.put("XOR_ENCRYPTION", 2);
        connectOptions.put("NOT_COMPRESSED", 1);
        connectOptions.put("ZLIB_COMPRESSED", 2);
        connectOptions.put("CLEAR_TEXT_AUTH", 1);
        connectOptions.put("SIMPLE_AUTH", 2);
        connectOptions.put("MD5_AUTH", 4);
    }
}

